using System;
using System.Collections.Generic;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public class Osoba
{
    #region Logika obiektu
    private int id;
    public int Id
    {
        get { return id; }
    }
    private string nazwisko;
    public string Nazwisko
    {
        get { return nazwisko; }
        set { nazwisko = value; }
    }

    private string imie;
    public string Imie
    {
        get { return imie; }
        set { imie = value; }
    }

	public Osoba() {}

    public Osoba( int id, string nazwisko, string imie )
    {
        this.id = id;
        this.nazwisko = nazwisko;
        this.imie = imie;
    }
    #endregion

    #region Object Data Binding
    /// <summary>
    /// Zwr list obiektw dla ktrych warunek jest speniony
    /// o zadanym porzdku posortowania
    /// i tylko wybrane elementy
    /// </summary>
    /// <param name="where"></param>
    /// <param name="sortOrder"></param>
    /// <param name="maximumRows"></param>
    /// <param name="startRowIndex"></param>
    /// <returns></returns>
    public static IList<Osoba> RetrievePage( string whereExpression, string sortOrder, int maximumRows, int startRowIndex )
    {
        // prawdziwa logika odwouje si np. do SQL
        List<Osoba> l = new List<Osoba>();

        for ( int i = startRowIndex; i < startRowIndex + maximumRows; i++ )
        {
            l.Add( new Osoba( i, "Nazwisko "+i.ToString(), "Imie "+i.ToString() ) );
        }

        return l;
    }

    /// <summary>
    /// Zwr list obiektw dla ktrych warunek jest speniony
    /// </summary>
    /// <param name="where"></param>
    /// <returns></returns>
    public static int TotalCount( string whereExpression )
    {
        // prawdziwa logika odwouje si np. do SQL
        return 111;
    }
    #endregion
}
