using System;
using System.Reflection;
using System.Security.Permissions;

namespace SecretReader
{
	class MainClass
	{
		[STAThread]
		static void Main(string[] args)
		{
			if ( args.Length > 0 )
			{
				string assemblyFile = args[0];
				string path = System.IO.Path.GetFullPath(args[0]);

				Assembly asm = Assembly.LoadFile(path);

				Console.WriteLine("Assembly full name:");
				Console.WriteLine(asm.FullName);
				Console.WriteLine();

				foreach ( Type t in asm.GetTypes() )
				{
					ScanPrivate(t);
				}
			}
		}

		/// <summary>
		/// Skanowanie typu ze wzgledu na prywatne pola i metody
		/// </summary>
		/// <param name="t">skanowany typ</param>
		[ReflectionPermission(SecurityAction.Deny, TypeInformation=true, MemberAccess=true)]
		static void ScanPrivate(Type t)
		{
			Console.WriteLine("Type: " + t.Name);
			Console.WriteLine();

			// szukamy publicznego konstruktora bezargumentwego 
			ConstructorInfo cr = t.GetConstructor(new Type[] {});
			object tInstance = null;

			if ( cr != null )
			{
				tInstance = cr.Invoke(null);
				Console.WriteLine("Default public constructor is available.");
			}

			// szukamy prywatnych pol i metod
			foreach ( MemberInfo mi in t.GetMembers(
				BindingFlags.Instance|
				BindingFlags.NonPublic|
				BindingFlags.Static|
				BindingFlags.DeclaredOnly) )
			{
				// pole
				if ( mi.MemberType == MemberTypes.Field )
				{
					FieldInfo fi = mi as FieldInfo;
					Console.Write("private field: " + fi.Name);

					if ( fi.IsStatic )
					{
						Console.Write("  static value: " + fi.GetValue(t));
					}
					else if ( tInstance != null )
					{
						Console.Write("  value: " + fi.GetValue(tInstance));
					}
					Console.WriteLine();
				}

				// metoda
				if ( mi.MemberType == MemberTypes.Method )
				{
					MethodInfo mei = mi as MethodInfo;
					Console.WriteLine("private method: " + mei.Name);

					// jesli metoda jest bezparametrowa to ja uruchamiamy
					if ( mei.GetParameters().Length == 0 )
					{
						if ( mei.IsStatic )
						{
							Console.WriteLine("Execution of static method...");
							mei.Invoke(t, null);
						}
						else if ( tInstance != null )
						{
							Console.WriteLine("Execution of private method...");
							mei.Invoke(tInstance, null);
						}
					}
				}
			}
		}
	}
}
