﻿namespace Uwr.Web.UIHelpers
{
    using System;
    using System.Collections;
    using System.ComponentModel;
    using System.Web.UI;
    using System.Web.UI.WebControls;

    public class OutputControlConverter : StringConverter
    {
        protected virtual object[] GetControls(IContainer container)
        {
            ArrayList list = new ArrayList();
            foreach (IComponent component in container.Components)
            {
                Control control = component as Control;
                if (control is TextBox)
                {
                    list.Add(string.Copy(control.ID));
                }
            }
            list.Sort();
            return list.ToArray();
        }

        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
        {
            if ((context != null) && (context.Container != null))
            {
                object[] values = this.GetControls(context.Container);
                if (values != null)
                {
                    return new TypeConverter.StandardValuesCollection(values);
                }
            }
            return null;
        }

        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context)
        {
            return false;
        }

        public override bool GetStandardValuesSupported(ITypeDescriptorContext context)
        {
            return true;
        }
    }
}

