using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace CustomControls
{
    public class ViewStateDemoLabel : WebControl
    {
        private string _text;


        public string Text
        {
            get
            {
                return ( _text == null ) ? String.Empty : _text;
            }
            set
            {
                _text = value;
            }
        }

        public string TextInViewState
        {
            get
            {
                object o = ViewState["TextInViewState"];
                return ( o == null ) ? String.Empty : (string)o;
            }
            set
            {
                ViewState["TextInViewState"] = value;
            }
        }

        protected override void RenderContents( HtmlTextWriter writer )
        {
            writer.Write( "Text = " );
            writer.Write( Text );
            writer.Write( "<br>" );
            writer.Write( "TextInViewState = " );
            writer.Write( TextInViewState );
        }
    }

}