using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace Uwr.MyControls
{
    public class TheProvider : WebPart, ITextContract
    {
        private TextBox contentTextLabel;
        private Button btnUpdate;

        protected override void CreateChildControls()
        {
            contentTextLabel = new TextBox();
            contentTextLabel.Text = "Sample Text";
            btnUpdate = new Button();
            btnUpdate.Text = "Update Text";

            this.Controls.Add( contentTextLabel );
            this.Controls.Add( btnUpdate );
        }

        public string TheContent
        {
            get 
            {
                EnsureChildControls();
                return contentTextLabel.Text; 
            }
            set 
            {
                EnsureChildControls();
                contentTextLabel.Text = value; 
            }
        }

        [ConnectionProvider( "The Content 2" )]
        public ITextContract GetTextCommunicationPoint()
        {
            return this as ITextContract;
        }
    }
}
