using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace Uwr.MyControls
{
    public class TheConsumer : WebPart
    {
        private ITextContract theProvider;
        private Label lblText;

        protected override void CreateChildControls()
        {
            lblText = new Label();
            this.Controls.Add( lblText );
        }

        [ConnectionConsumer( "The Content" )]
        public void InitializeProvider( ITextContract provider )
        {
            theProvider = provider;
        }

        protected override void OnPreRender( EventArgs e )
        {
            base.OnPreRender( e );

            if ( theProvider != null )
            {
                lblText.Text = theProvider.TheContent;
            }
        }
    }

}