﻿using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;

namespace Uwr.Web.UIHelpers
{
    [DefaultProperty("ControlToValidate"), ToolboxData("<{0}:MultiLineTextBoxValidator runat=\"server\" \r\n\t\tMaxLength=\"100\" \r\n\t\tEnableClientSideRestriction=\"True\" \r\n\t\tShowJavascriptAlert=\"False\" \r\n\t\tShowCharacterCount=\"False\" />")]
    public class MultiLineTextBoxValidator : BaseValidator
    {
        private TextBox ControlToValidateRef;
        private string COUNT_JAVASCRIPT = "\r\n\t\t\t<script type=\"text/javascript\"><!--\r\n\r\n\t\t\t\tfunction countChars(controlToValidateRef,\r\n\t\t\t\t\tmaxLength,\r\n\t\t\t\t\toutputControlRef,\r\n\t\t\t\t\terrorMessage,\r\n\t\t\t\t\tenableClientSideRestriction,\r\n\t\t\t\t\tshowJavascriptAlert,\r\n\t\t\t\t\tshowCharacterCount) {\r\n\r\n\t\t\t\t\tvar countString = maxLength - controlToValidateRef.value.length;\r\n\t\t\t\t\tif (countString < 0) {\r\n\t\t\t\t\t\tif (enableClientSideRestriction) {\r\n\t\t\t\t\t\t\tcontrolToValidateRef.value = controlToValidateRef.value.substring( 0, maxLength );\r\n\t\t\t\t\t\t\tif (showJavascriptAlert) {\r\n\t\t\t\t\t\t\t\talert(errorMessage);\r\n\t\t\t\t\t\t\t}\r\n\t\t\t\t\t\t\treturn false;\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t} else {\r\n\t\t\t\t\t\tif (showCharacterCount) {\r\n\t\t\t\t\t\t\toutputControlRef.value = countString;\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t}\r\n\t\t\t\t}\r\n\r\n\t\t\t\t//-->\r\n\t\t\t</script>";
        private bool enableClientSideRestriction = true;
        private int maxLength = 100;
        private string outputControl;
        private bool showCharacterCount = false;
        private bool showJavascriptAlert = false;

        protected override bool EvaluateIsValid()
        {
            TextBox box;
            try
            {
                box = (TextBox) this.Parent.FindControl(base.ControlToValidate);
            }
            catch (NullReferenceException exception)
            {
                throw new ApplicationException(string.Format("Control referenced by \"ControlToValidate\" ({0}) could not be found.", base.ControlToValidate), exception);
            }
            catch (InvalidCastException exception2)
            {
                throw new ApplicationException(string.Format("Control referenced by \"ControlToValidate\" attribute must be of type System.UI.WebControls.TextBox.", new object[0]), exception2);
            }
            return (box.Text.Length <= this.MaxLength);
        }

        public string GetControlReference(Control ctrl)
        {
            Control parent = ctrl.Parent;
            while (!(parent is HtmlForm))
            {
                parent = parent.Parent;
            }
            return string.Format("document.{0}.elements['{1}']", parent.ClientID, ctrl.UniqueID);
        }

        protected override void OnPreRender(EventArgs e)
        {
            base.OnPreRender(e);
            string id = "";
            TextBox ctrl = new TextBox();
            if (this.showCharacterCount)
            {
                try
                {
                    id = this.outputControl.Trim();
                    ctrl = (TextBox) this.FindControl(id);
                }
                catch (NullReferenceException exception)
                {
                    throw new ApplicationException(string.Format("Control referenced by \"OutputControl\" ({0}) could not be found.", id), exception);
                }
                if (base.ControlToValidate.Equals(this.OutputControl))
                {
                    throw new ApplicationException(string.Format("\"ControlToValidate\" and \"OutputControl\" cannot reference the same control.", new object[0]));
                }
            }
            if (this.MaxLength < 0)
            {
                throw new ApplicationException("\"MaxLength\" property must be greater than 0.");
            }
            try
            {
                string text;
                System.Web.UI.AttributeCollection attributes;
                if (base.ControlToValidate == "")
                {
                    throw new ApplicationException(string.Format("\"ControlToValidate\" property must be set.", new object[0]));
                }
                this.ControlToValidateRef = (TextBox) this.FindControl(base.ControlToValidate);
                if (this.Text != "")
                {
                    text = this.Text;
                }
                else
                {
                    text = base.ErrorMessage;
                }
                string text3 = "";
                if (this.showCharacterCount)
                {
                    text3 = string.Format("countChars(this, {0}, {1}, '{2}', {3}, {4}, {5});", new object[] { this.maxLength, this.GetControlReference(ctrl), text, this.enableClientSideRestriction.ToString().ToLower(), this.showJavascriptAlert.ToString().ToLower(), this.showCharacterCount.ToString().ToLower() });
                }
                else
                {
                    text3 = string.Format("countChars(this, {0}, {1}, '{2}', {3}, {4}, {5});", new object[] { this.maxLength, "''", text, this.enableClientSideRestriction.ToString().ToLower(), this.showJavascriptAlert.ToString().ToLower(), this.showCharacterCount.ToString().ToLower() });
                }
                (attributes = this.ControlToValidateRef.Attributes)["OnKeyUp"] = attributes["OnKeyUp"] + text3;
                (attributes = this.ControlToValidateRef.Attributes)["OnChange"] = attributes["OnChange"] + text3;
                (attributes = this.ControlToValidateRef.Attributes)["OnFocus"] = attributes["OnFocus"] + text3;
                (attributes = this.ControlToValidateRef.Attributes)["OnBlur"] = attributes["OnBlur"] + text3;
                this.Page.ClientScript.RegisterClientScriptBlock( Page.GetType(), "COUNT_JAVASCRIPT", this.COUNT_JAVASCRIPT);
                if (this.showCharacterCount)
                {
                    TextBox box2 = (TextBox) this.FindControl(id);
                    box2.ReadOnly = true;
                    box2.Text = (this.maxLength - this.ControlToValidateRef.Text.Length).ToString();
                }
            }
            catch (NullReferenceException exception2)
            {
                throw new ApplicationException(string.Format("Control referenced by \"ControlToValidate\" ({0}) could not be found.", base.ControlToValidate), exception2);
            }
            catch (InvalidCastException exception3)
            {
                throw new ApplicationException(string.Format("Control referenced by \"ControlToValidate\" attribute must be of type System.UI.WebControls.TextBox.", new object[0]), exception3);
            }
        }

        [DefaultValue("True"), Category("Behavior"), Description("Indicates whether to restrict text entry of the ControlToValidate if its length exceeds MaxLength")]
        public bool EnableClientSideRestriction
        {
            get
            {
                return this.enableClientSideRestriction;
            }
            set
            {
                this.enableClientSideRestriction = value;
            }
        }

        [DefaultValue(100), Category("Behavior"), Description("Maximum length in characters of the contents of the ControlToValidate")]
        public int MaxLength
        {
            get
            {
                return this.maxLength;
            }
            set
            {
                this.maxLength = value;
            }
        }

        [TypeConverter(typeof(OutputControlConverter)), Category("Behavior"), Description("ID of the TextBox to display the character count in")]
        public string OutputControl
        {
            get
            {
                return this.outputControl;
            }
            set
            {
                this.outputControl = value;
            }
        }

        [Description("Indicates whether to show the number of characters remaining in the OutputControl"), DefaultValue("False"), Category("Behavior")]
        public bool ShowCharacterCount
        {
            get
            {
                return this.showCharacterCount;
            }
            set
            {
                this.showCharacterCount = value;
            }
        }

        [DefaultValue("False"), Description("Indicates whether to show a Javascript alert if the length exceeds MaxLength"), Category("Behavior")]
        public bool ShowJavascriptAlert
        {
            get
            {
                return this.showJavascriptAlert;
            }
            set
            {
                this.showJavascriptAlert = value;
            }
        }
    }
}

