using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.IO;
using System.Web.UI;

/* Wiktor Zychla, 2007 */
namespace AppOffline
{
    public class AppOfflineHandler : IHttpHandler
    {
        string appOffline;
        /// <summary>
        /// appoffline.htm file content as singleton
        /// </summary>
        public string AppOffline
        {
            get
            {
                if ( appOffline == null )
                    appOffline = OfflineFileContent;

                return appOffline;
            }
        }

        /// <summary>
        /// Path to the appoffline.htm file
        /// </summary>
        public string OfflineFilePath
        {
            get
            {
                return context.Server.MapPath( "~/appoffline.htm" );
            }
        }

        /// <summary>
        /// appoffline.htm file content
        /// </summary>
        public string OfflineFileContent
        {
            get
            {
                return File.ReadAllText( OfflineFilePath );
            }
        }

        /// <summary>
        /// Is the application in the offline mode?
        /// 
        /// Yes - if the appoffline.htm exists
        /// </summary>
        public bool IsOffline
        {
            get
            {
                return File.Exists( OfflineFilePath );
            }
        }

        HttpContext context;

        #region IHttpHandler Members
        public bool IsReusable
        {
            get
            {
                return true;
            }
        }

        public void ProcessRequest( HttpContext context )
        {
            this.context = context;

            // offline mode and remote request?
            if ( !context.Request.IsLocal &&
                 IsOffline
                )
            {
                context.Response.Clear();
                context.Response.Write( AppOffline );

                context.Response.End();
            }
            else
                // redirect to the default processing pipe
                PageParser.GetCompiledPageInstance(
                    context.Request.Path,
                    context.Request.PhysicalPath,
                    context ).ProcessRequest( context );
        }
        #endregion
    }
}
