﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Web.UI;
using System.Web;

namespace SimpleValidatorLibrary
{
    [Designer( typeof( OddityValidatorDesigner ) )]
    public class OddityValidator : BaseValidator
    {
        private TextBox controlToValidate;

        protected override bool ControlPropertiesValid()
        {
            bool valid = false;

            if ( ControlToValidate != null )
            {
                Control control = FindControl( ControlToValidate );

                if ( control is TextBox )
                {
                    controlToValidate = (TextBox)control;
                    valid = true;
                }
            }

            return valid;
        }

        protected override void OnPreRender( EventArgs e )
        {
            // sprawdzenie, czy przeglądarka wspiera JS
            if ( EnableClientScript )
                if ( HttpContext.Current.Request.Browser.EcmaScriptVersion.Major >= 1 )
                    RegisterClientScript();

            base.OnPreRender( e );
        }

        protected override bool EvaluateIsValid()
        {
            return isNumberValid( controlToValidate.Text );
        }

        protected override void AddAttributesToRender( HtmlTextWriter writer )
        {
            base.AddAttributesToRender( writer );
            if ( this.DetermineRenderUplevel() && this.EnableClientScript )
            {
                Page.ClientScript.RegisterExpandoAttribute( this.ClientID, "evaluationfunction", "number_verify" );
            }
        }

        #region funkcja do walidacji (client-side)

        /// <summary>
        /// Emits JavaScript validation code to the client.
        /// </summary>
        protected void RegisterClientScript()
        {
            this.Attributes["evaluationfunction"] = "number_verify";

            StringBuilder sb_Script = new StringBuilder();

            sb_Script.Append( "<script type=\"text/javascript\">" );
            sb_Script.Append( "\r" );
            sb_Script.Append( "\r" );

            sb_Script.Append( "function number_verify(_validator) {" );
            sb_Script.Append( "\r" );
            sb_Script.Append( "  var strNumber  = document.getElementById(document.getElementById(_validator.id).controltovalidate).value;\r" );
            sb_Script.Append( "  return isNumberValid(strNumber);\r" );
            sb_Script.Append( "}" );
            sb_Script.Append( "\r" );

            sb_Script.Append( "function isNumberValid(strNumber) {\r" );
            sb_Script.Append( "  if ( strNumber == null || strNumber.length == 0 ) return true;\r" );
            sb_Script.Append( "\r" );
            sb_Script.Append( "	var number = parseInt( strNumber )\r" );
            sb_Script.Append( "	return (number % 2)==1;\r" );
            sb_Script.Append( "}" );
            sb_Script.Append( "\r" );

            sb_Script.Append( "</script>" );
            Page.ClientScript.RegisterClientScriptBlock( this.GetType(), "OddityValidation", sb_Script.ToString() );
        }

        #endregion

        #region funkcje do walidacji (server-side)

        private bool isNumberValid( string number )
        {
            // pusty przechodzi
            if ( string.IsNullOrEmpty( number ) ) return true;

            try
            {
                return ( int.Parse( number ) % 2 ) == 1;
            }
            catch
            {
                return false;
            }
        }

        #endregion

    }
}
