﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using UnitTests.FakeViews;
using Microsoft.Practices.Unity;
using Microsoft.Practices.Prism.Events;
using WindowsFormsApplication2.UserList;
using Microsoft.Practices.ServiceLocation;
using WindowsFormsApplication2.AddUser;

namespace UnitTests
{
    [TestFixture]
    public class ModelViewPresenterTests
    {
        [SetUp]
        public void Setup()
        {
            IUnityContainer container = new UnityContainer();

            container.RegisterType<IEventAggregator, EventAggregator>( new ContainerControlledLifetimeManager() );

            container.RegisterType<IFrmUserList, FakeFrmUserList>();
            container.RegisterType<IFrmAddUser, FakeFrmAddUser>();

            UnityServiceLocator locator = new UnityServiceLocator( container );
            ServiceLocator.SetLocatorProvider( () => locator );

        }

        [Test]
        public void TestAddNewUserFlow()
        {
            // arrange
            FakeFrmUserList frm = new FakeFrmUserList();

            int cb = frm.Items.Count();

            // act
            frm.RaiseAddNewUser();

            // assert
            int ca = frm.Items.Count();
            Assert.AreEqual( ca, cb + 1 );
        }
    }
}
