﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DataLayer;
using Microsoft.Practices.ServiceLocation;
using Microsoft.Practices.Prism.Events;
using WindowsFormsApplication2.Events;

namespace WindowsFormsApplication2.AddUser
{
    public class FrmAddUserPresenter
    {
        IFrmAddUser _view;

        public FrmAddUserPresenter( IFrmAddUser view )
        {
            this._view = view;
        }

        public void AddNewUser( string Name, string Surname )
        {
            using ( UserListDataContext ctx = new UserListDataContext() )
            {
                User user = new User();
                user.Name = Name;
                user.Surname = Surname;

                ctx.Users.InsertOnSubmit( user );
                ctx.SubmitChanges();

                var ea = ServiceLocator.Current.GetInstance<IEventAggregator>();
                ea.GetEvent<AddNewUserEvent>().Publish( user );
            }
        }
    }
}
