﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using WindowsFormsApplication2.UserList;
using Microsoft.Practices.Unity;
using Microsoft.Practices.Prism.Events;
using Microsoft.Practices.ServiceLocation;
using WindowsFormsApplication2.AddUser;

namespace WindowsFormsApplication2
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            CreateDependencies();

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault( false );
            Application.Run( new FrmUserList() );
        }

        static void CreateDependencies()
        {
            IUnityContainer container = new UnityContainer();

            container.RegisterType<IEventAggregator, EventAggregator>( new ContainerControlledLifetimeManager() );

            container.RegisterType<IFrmUserList, FrmUserList>();
            container.RegisterType<IFrmAddUser, FrmAddUser>();

            UnityServiceLocator locator = new UnityServiceLocator( container );
            ServiceLocator.SetLocatorProvider( () => locator );
        }
    }
}
