﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RepositoryLayer.EntityFramework
{
    public class EFUnitOfWork : UnitOfWork
    {
        #region UnitOfWork Members

        UserListContext _context;

        public EFUnitOfWork( UserListContext context )
        {
            this._context = context;
        }

        private GenericRepository<DomainModel.IUser> _userRepository;
        public GenericRepository<DomainModel.IUser> UserRepository
        {
            get 
            {
                if ( _userRepository == null )
                    _userRepository = new EFUserRepository( this._context );

                return _userRepository;
            }
        }

        #endregion



        #region UnitOfWork Members


        public void Save()
        {
            this._context.SaveChanges();
        }

        #endregion

        #region IDisposable Members

        public void Dispose()
        {
            this._context.Dispose();
        }

        #endregion
    }
}
