﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DataLayer;

namespace RepositoryLayer.Linq2Sql
{
    public class Linq2SqlUnitOfWork : UnitOfWork
    {
        #region UnitOfWork Members

        UserListDataContext _context;

        public Linq2SqlUnitOfWork( UserListDataContext context )
        {
            this._context = context;
        }

        private GenericRepository<DomainModel.IUser> _userRepository;
        public GenericRepository<DomainModel.IUser> UserRepository
        {
            get 
            {
                if ( _userRepository == null )
                    _userRepository = new Linq2SqlUserRepository( this._context );

                return _userRepository;
            }
        }

        #endregion



        #region UnitOfWork Members


        public void Save()
        {
            this._context.SubmitChanges();
        }

        #endregion

        #region IDisposable Members

        public void Dispose()
        {
            this._context.Dispose();
        }

        #endregion
    }
}
