﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DomainModel;
using DataLayer;

namespace RepositoryLayer.Linq2Sql
{
    public class Linq2SqlUserRepository : GenericRepository<IUser>
    {
        #region GenericRepository<IUser> Members

        private UserListDataContext _context { get; set; }

        public Linq2SqlUserRepository( UserListDataContext context )
        {
            this._context = context;
        }

        public IQueryable<IUser> Query
        {
            get 
            {
                return _context.Users; 
            }
        }

        public IUser New()
        {
            return new User();
        }

        public void Insert( IUser item )
        {
            if ( item is User )
            {
                this._context.Users.InsertOnSubmit( (User)item );
                return;
            }

            throw new ArgumentException();
            //throw new NotImplementedException();
        }

        public void Update( IUser item )
        {
            //throw new NotImplementedException();
        }

        public void Delete( IUser item )
        {
            //throw new NotImplementedException();
        }

        #endregion
    }
}
