﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DataLayer;
using Microsoft.Practices.ServiceLocation;
using Microsoft.Practices.Prism.Events;
using WindowsFormsApplication2.Events;
using RepositoryLayer;
using DomainModel;

namespace WindowsFormsApplication2.AddUser
{
    public class FrmAddUserPresenter
    {
        IFrmAddUser _view;

        public FrmAddUserPresenter( IFrmAddUser view )
        {
            this._view = view;
        }

        public void AddNewUser( string Name, string Surname )
        {
            //using ( UserListDataContext ctx = new UserListDataContext() )
            using ( var unitOfWork = ServiceLocator.Current.GetInstance<UnitOfWork>() )
            {
                //User user = new User();
                //user.Name = Name;
                //user.Surname = Surname;

                IUser user = unitOfWork.UserRepository.New();

                user.Name = Name;
                user.Surname = Surname;

                unitOfWork.UserRepository.Insert( user );

                //ctx.Users.InsertOnSubmit( user );
                //ctx.SubmitChanges();

                unitOfWork.Save();

                var ea = ServiceLocator.Current.GetInstance<IEventAggregator>();
                ea.GetEvent<AddNewUserEvent>().Publish( user );
            }
        }
    }
}
