﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using WindowsFormsApplication2.UserList;
using Microsoft.Practices.Unity;
using Microsoft.Practices.Prism.Events;
using Microsoft.Practices.ServiceLocation;
using WindowsFormsApplication2.AddUser;
using DomainModel;
using RepositoryLayer;
using RepositoryLayer.Linq2Sql;
using DataLayer;
using RepositoryLayer.EntityFramework;

namespace WindowsFormsApplication2
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            CreateDependencies();

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault( false );


            Application.Run( new FrmUserList() );
        }

        static void CreateDependencies()
        {
            IUnityContainer container = new UnityContainer();

            container.RegisterType<IEventAggregator, EventAggregator>( new ContainerControlledLifetimeManager() );

            // widoki
            container.RegisterType<IFrmUserList, FrmUserList>();
            container.RegisterType<IFrmAddUser, FrmAddUser>();

            // repozytoria
            //container.RegisterType<UserListDataContext>( new InjectionFactory( c => new UserListDataContext() ) );

            //container.RegisterType<GenericRepository<IUser>, Linq2SqlUserRepository>();
            //container.RegisterType<UnitOfWork, Linq2SqlUnitOfWork>();

            container.RegisterType<UserListDataContext>( new InjectionFactory( c => new UserListContext() ) );

            container.RegisterType<GenericRepository<IUser>, EFUserRepository>();
            container.RegisterType<UnitOfWork, EFUnitOfWork>();

            UnityServiceLocator locator = new UnityServiceLocator( container );
            ServiceLocator.SetLocatorProvider( () => locator );
        }
    }
}
