﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DataLayer;
using WindowsFormsApplication2.AddUser;
using Microsoft.Practices.ServiceLocation;
using Microsoft.Practices.Prism.Events;
using WindowsFormsApplication2.Events;
using RepositoryLayer;

namespace WindowsFormsApplication2.UserList
{
    public class FrmUserListPresenter
    {
        public IFrmUserList _view;

        public FrmUserListPresenter( IFrmUserList view )
        {
            this._view = view;
        }

        public void ShowUserList()
        {
            //listBox1.Items.Clear();

            /*
            using ( UserListDataContext ctx = new UserListDataContext() )
            {
                this._view.SetDataSource( ctx.Users.ToList().Select( u => string.Format( "{0} {1}", u.Name, u.Surname ) ).ToList() );
            }
             */

            using ( var unitOfWork = ServiceLocator.Current.GetInstance<UnitOfWork>() )
            {
                this._view.SetDataSource( unitOfWork.UserRepository.Query.ToList().Select( u => string.Format( "{0} {1}", u.Name, u.Surname ) ).ToList() );
            }

            // ports and adapters, hexagonal architecture
            // onion architecture
        }

        public void ShowFrmAddUser()
        {
            IFrmAddUser frm = ServiceLocator.Current.GetInstance<IFrmAddUser>();
            frm.ShowDialog();
        }

        SubscriptionToken token;

        public void RegisterSubscriptions()
        {
            var ea = ServiceLocator.Current.GetInstance<IEventAggregator>();
            token = ea.GetEvent<AddNewUserEvent>().Subscribe( u => ShowUserList() );
        }

        public void UnregisterSubscriptions()
        {
            var ea = ServiceLocator.Current.GetInstance<IEventAggregator>();
            if ( token != null )
                ea.GetEvent<AddNewUserEvent>().Unsubscribe( token );
        }

    }
}
