﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApplication2.UserList;

namespace UnitTests.FakeViews
{
    public class FakeFrmUserList : IFrmUserList
    {
        FrmUserListPresenter _presenter;

        public FakeFrmUserList()
        {
            this.Items = Enumerable.Empty<string>();


            this._presenter = new FrmUserListPresenter( this );

            this._presenter.ShowUserList();
            this._presenter.RegisterSubscriptions();
        }

        #region IFrmUserList Members

        public void SetDataSource( IEnumerable<string> dataSource )
        {
            this.Items = dataSource;
        }

        #endregion

        #region Interfejs dla testowania

        public IEnumerable<string> Items { get; set; }

        public void RaiseAddNewUser()
        {
            this._presenter.ShowFrmAddUser();
        }

        #endregion
    }
}
