﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DomainModel;

namespace RepositoryLayer.EntityFramework
{
    public class EFUserRepository : GenericRepository<IUser>
    {
        public UserListContext _context;

        public EFUserRepository( UserListContext context )
        {
            this._context = context;
        }

        #region GenericRepository<IUser> Members

        public IQueryable<IUser> Query
        {
            get 
            {
                return this._context.Users;
            }
        }

        public IUser New()
        {
            return new User();
        }

        public void Insert( IUser item )
        {
            if ( item is User )
            {
                this._context.Users.Add( (User)item );
                return;
            }

            throw new ArgumentException();
        }

        public void Update( IUser item )
        {
            throw new NotImplementedException();
        }

        public void Delete( IUser item )
        {
            throw new NotImplementedException();
        }

        #endregion
    }
}
