﻿using SharedModel;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Net.Http.Formatting;
using System.Net.Http.Headers;
using System.Text;
using System.Threading.Tasks;

namespace WebApiClient
{
    class Program
    {
        static void Main(string[] args)
        {
            HttpClient client = new HttpClient();
            client.BaseAddress = new Uri("http://localhost:8087/");
            //client.BaseAddress = new Uri("http://localhost:49774/");

            
            // Add an Accept header for JSON format.
            client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));

            HttpResponseMessage response = client.GetAsync("api/user").Result;
            var users = response.Content.ReadAsAsync<IEnumerable<UserDTO>>().Result;

            foreach (var user in users)
            {
                Console.WriteLine("{0} {1}", user.Name, user.Surname);
            }

            UserDTO newuser = new UserDTO() { Name = "newfoo", Surname = "newbar" };
            HttpResponseMessage create = client.PostAsync<UserDTO>("api/user", newuser, new JsonMediaTypeFormatter() ).Result;
            Console.WriteLine(create.StatusCode.ToString());

            Console.ReadLine();
        }
    }
}
